(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* TRACE.MLI *)
(* Author: Mark Hayden, 3/96 *)
(**************************************************************)

val source_report : bool ref

val source_file : string -> string

val config : string -> string -> unit

val declare_test : string -> (unit -> unit) -> unit
val exec_test : string -> unit

val print_config : unit -> unit

val log : string -> string -> (unit -> string) -> unit
val logl : string -> string -> (unit -> string list) -> unit
val list_of_logs : unit -> string list

val add_log : string -> (string -> string -> unit) -> unit
val rmv_log : string -> unit

val install : (unit -> unit) -> unit

(**************************************************************)

val install_root : (unit -> string list) -> unit

val print_roots : unit -> unit

(**************************************************************)

val comment : string -> unit

val print_comments : unit -> unit

(**************************************************************)
