(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* TIMESTAMP.ML *)
(* Author: Mark Hayden, 4/97 *)
(**************************************************************)
open Util

let start = Hsys.gettimeofday ()

let pending = ref []

let add msg () =
  pending := (msg,Hsys.gettimeofday ()) :: !pending

let addtime msg time =
  pending := (msg,time) :: !pending

let print () =
  let count = ref 0 in
  let tot = ref 0.0 in

  let last = ref (-1.0) in
  let targ = ref [] in
  let last_msg = ref "" in
  let nsamples = List.length !pending in
  if nsamples > 0 then (
    eprintf "TIMESTAMP:print\n" ;
    List.iter (fun (msg,time) ->
      eprintf "  %10.6f (%10.6f) %s\n" (time -. start) (time -. !last) msg ;
      if !last_msg = "UDP:recv" 
      && msg = "UDP:xmit" 
      && time -. !last < 0.001
      then (
	incr count ;
	tot := !tot +. (time -. !last) ;
	targ := (time -. !last) :: !targ ;
      ) ;

      last := time ;
      last_msg := msg ;
    ) (List.rev !pending) ;
    pending := [] ;
    let targ = Sort.list (>) !targ in
    let median = 
      try 
	List.nth targ (List.length targ / 2)
      with _ -> (-1.0)
    in
    eprintf "  (count=%d, ave=%10.6f, med=%10.6f)\n" !count (!tot /. (float !count)) median
  )

let timers = ref []

let use n = timers := n :: !timers

let check n = List.mem n !timers
