(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* SCHED.MLI: call-back scheduling *)
(* Author: Mark Hayden, 12/95 *)
(**************************************************************)

type t

val enqueue : t -> (unit -> unit) -> unit
val enqueue_1arg : t -> ('a -> unit) ->  'a -> unit
val enqueue_2arg : t -> ('a -> 'b -> unit) -> 'a -> 'b -> unit
val enqueue_3arg : t -> ('a -> 'b -> 'c -> unit) -> 'a -> 'b -> 'c -> unit
val enqueue_4arg : t -> ('a -> 'b -> 'c -> 'd -> unit) -> 'a -> 'b -> 'c -> 'd -> unit
val on : t -> unit
val off : t -> unit
val empty : t -> bool
val size : t -> int
val step : t -> int -> bool
val create : string -> t
val steps : int ref
