(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* Resource.MLI *)
(* Author: Mark Hayden, 4/96 *)
(**************************************************************)

type ('a,'b) t

type name = string

val create 	: 
  name -> 
  ('a -> 'b -> unit) ->			(* add *)
  ('a -> unit) -> 			(* remove *)
  (('a,'b) t -> unit) ->		(* change *)
  ('a,'b) t
val simple 	: name -> ('a,'b) t
val add       	: ('a,'b) t -> 'a -> 'b -> unit
val remove 	: ('a,'b) t -> 'a -> unit
val to_list	: ('a,'b) t -> 'a list
val to_list2	: ('a,'b) t -> 'b list
val to_list_ref	: ('a,'b) t -> 'a list ref
val to_list2_ref : ('a,'b) t -> 'b list ref

val info	: ('a,'b) t -> string
val verbose 	: bool ref
