(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* RESOURCE.ML *)
(* Author: Mark Hayden, 4/96 *)
(**************************************************************)
open Printf
(**************************************************************)
let name = "RESOURCE"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)

let verbose = ref false

type name = string

type ('a,'b) t = {
  name 		: name ;
  first 	: 'a -> 'b -> unit ;
  last 		: 'a -> unit ;
  change	: ('a,'b) t -> unit ;
  list 		: 'a list ref ;
  list2 	: 'b list ref ;
  table 	: ('a,(int ref * 'b)) Hashtbl.t
}

(**************************************************************)

let create name first last change = {
  name 	= name ;
  first = first ;
  last 	= last ;
  table = Hashtbl.create 10 ;
  list 	= ref [] ;
  list2 = ref [] ;
  change = change
}

(**************************************************************)

let simple name =
  create name (fun _ _ -> ()) (fun _ -> ()) (fun _ -> ())

(**************************************************************)

let debug t =
  if !verbose then (
    eprintf "RESOURCE:%s:size=%d\n" 
      t.name (Util.hashtbl_size t.table)
  )

(**************************************************************)

let update e =
  e.list := [] ;
  e.list2 := [] ;
  Hashtbl.iter (fun k (_,d) ->
    e.list := k :: !(e.list) ;
    e.list2 := d :: !(e.list2)
  ) e.table ;
  e.change e

(**************************************************************)

let add e k d =
  try
    let (ctr,_) = Hashtbl.find e.table k in
    incr ctr
  with Not_found -> (
    e.first k d ;
    Hashtbl.add e.table k (ref 1,d) ;
    update e
  ) ;
  debug e

(**************************************************************)

let remove e v =
  try
    let (ctr,_) = Hashtbl.find e.table v in
    decr ctr ;
    if !ctr = 0 then (
      e.last v ;
      Hashtbl.remove e.table v ;
      update e
    )
  with Not_found -> (
    failwith "remove:no such item in table"
  ) ;
  debug e

(**************************************************************)

let to_list  r = !(r.list)
let to_list2 r = !(r.list2)

let to_list_ref  r = r.list
let to_list2_ref r = r.list2

(**************************************************************)

let info r =
  sprintf "RESOURCE:name=%s:size=%d" 
    r.name (Util.hashtbl_size r.table)

(**************************************************************)
