(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* REFCNT.MLI : manage our own pools of objects *)
(* Author: Mark Hayden, 3/95 *)
(**************************************************************)
open Trans
(**************************************************************)
val actually_use_counts : bool ref
val force_major_gc : bool ref
(**************************************************************)

(* Handles to refcnt'd objects.
 *)
type 'a t

(* Pools of these objects.
 *)
type 'a pool

(* Allocation from a pool.
 *)
val alloc : debug -> 'a pool -> 'a t

(* Reference count updates.
 *)
val incr : debug -> 'a t -> unit
val decr : debug -> 'a t -> unit
val check : debug -> 'a t -> unit

(* Access the object.
 *)
(*
val read : debug -> 'a t -> ('a -> 'b) -> 'b
*)
val read : debug -> 'a t -> 'a

(* The void handle.  This will be disregarded
 * by this module.
 *)
val void : debug -> 'a -> 'a t

(**************************************************************)
(* Create your own pool of objects.
 *)

type nlive = int
type nfree = int

val pool :
  debug ->				(* Debugging name *)
  (unit -> 'a) ->			(* Alloc *)
  ('a -> unit) ->			(* Release *)
  (nlive -> nfree -> 'a list) ->	(* Refill policy function *)
  'a pool				(* Pool object *)

val pool_debug : 'a pool -> string list

(**************************************************************)
