(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)

(* Note: this file is modified from the Caml Light 7.1
 * distribution.  Does the above copyright apply?
 *)

type 'a queue_cell =
    Nil
  | Cons of 'a * 'a queue_cell ref

type 'a t =
  { mutable head: 'a queue_cell;
    mutable tail: 'a queue_cell }

let create () =
  { head = Nil; tail = Nil }

let clear q =
  q.head <- Nil; q.tail <- Nil

let add x = function
    { tail = Nil } as q ->    (* if tail = Nil then head = Nil *)
      let c = Cons(x, ref Nil) in
        q.head <- c; q.tail <- c
  | { tail = Cons(_, newtail) } as q ->
      let c = Cons(x, ref Nil) in
        newtail := c; q.tail <- c

let peek q =
  match q.head with
    Nil ->
      raise Queue.Empty
  | Cons(x,_) ->
      x

let empty = function
| {head = Nil} -> true
| _ -> false


let take q =
  match q.head with
    Nil ->
      raise Queue.Empty
  | Cons(x, rest) ->
      q.head <- !rest;
      begin match !rest with
        Nil -> q.tail <- Nil
      |  _  -> ()
      end;
      x

let rec length_aux = function
    Nil -> 0
  | Cons(_, rest) -> succ (length_aux !rest)

let length q = length_aux q.head

let rec iter_aux f = function
    Nil ->
      ()
  | Cons(x, rest) ->
      f x; iter_aux f !rest

let iter f q = iter_aux f q.head

(* Construction in progress...

type 'a t = {
  mutable head : int ;
  mutable tail : int ;
  mutable array : 'a array
}

let create () = {
  head = 0 ;
  tail = 0 ;
  array = [|None|]
}

let grow q =
  let o = q.array in
  let l = Array.length o in
  let n = array_create name None (l * 2) in
  let h = q.head in
  let t = q.tail in
  if t <= h then (
    let len = h - t in
    Array.blit o q.tail n 0 len ;
    q.tail <- 0 ;
    q.head <- len
  ) else (
    let len = h - t + Array.length in
    Array.blit o q.tail n 0 

let add i q =
  let tail = q.tail in
  if 
    if tail = 0 then q.head = pred (Array.length q.array)
    else pred tail = q.head
  then 
    grow q ;
  let tail = q.tail in
  q.array.(tail) <- Some i ;
  q.tail <- pred (if tail = 0 then Array.length q.array else tail)

let take q =
  let head = q.head in
  if q.head = q.tail then 
    raise Empty ;
  let item = q.array.(head) in
  q.array.(head) <- None ;
  q.head <- pred (if head = 0 then Array.length q.array else head) ;
  item
*)
