(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* PRIQ.MLI: heap-based priority queues *)
(* Author: Mark Hayden, 3/96 *)
(**************************************************************)

type ('a,'b) t

val create 	: 'a -> ('a,'b) t
val add 	: ('a,'b) t -> 'a -> 'b -> unit

val get 	: ('a,'b) t -> ('a -> 'b -> unit) -> 'a -> bool

(* GETOPT: specialized form of "get" (note that the callback
 * is made with the value passed in instead of the interned 
 * value.
 *)
val getopt 	: ('a,'a -> unit) t -> 'a -> bool

val size 	: ('a,'b) t -> int
val min 	: ('a,'b) t -> 'a	(* BUGGY *)
val take 	: ('a,'b) t -> 'b
val empty 	: ('a,'b) t -> bool
val to_list	: ('a,'b) t -> ('a * 'b) list
val clear       : ('a,'b) t -> ('a -> 'b -> unit) -> unit

(**************************************************************)
(* Functorized version. 
 *)

module type OrderedType =
  sig
    type t
    val zero : t
    val ge : t -> t -> bool
  end
(*
module type S =
  sig
    type key
    type 'data t
    val create : unit -> 'data t
    val add : 'data t -> key -> 'data -> unit
    val get : 'data t -> (key -> 'data -> unit) -> key -> bool
    val getopt : (key -> unit) t -> key -> bool
    val size : 'data t -> int
    val min : 'data t -> key	(* BUGGY *)
    val take : 'data t -> 'data
    val empty : 'data t -> bool
    val to_list	: 'data t -> (key * 'data) list
  end

module Make(Ord : OrderedType): (S with type key = Ord.t)
*)
