(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* MARSH.MLI *)
(* Author: Mark Hayden, 12/96 *)
(**************************************************************)

exception Error of string

(**************************************************************)

(* Type of marshalled objects: used at sender.
 *)
type marsh

(* INIT: initializes a marshaller.
 *)
val init : unit -> marsh

(* Functions for adding data to a string.
 *)
val write_int : marsh -> int -> unit
val write_bool : marsh -> bool -> unit
val write_string : marsh -> string -> unit
val write_list : marsh -> ('a -> unit) -> 'a list -> unit
val write_option : marsh -> ('a -> unit) -> 'a option -> unit

(* MARSH: convert a marshaller into a string.
 *)
val marsh : marsh -> string

(**************************************************************)

(* Type of unmarshalling objects: used at receiver.
 *)
type unmarsh

(* UNMARSH: Convert a string into an unmarsh object.
 *)
val unmarsh : string -> unmarsh

(* Functions for reading from marshalled objects.
 *)
val read_int : unmarsh -> int
val read_bool : unmarsh -> bool
val read_string : unmarsh -> string
val read_list : unmarsh -> (unit -> 'a) -> 'a list
val read_option : unmarsh -> (unit -> 'a) -> 'a option

(**************************************************************)
