(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* LSET.ML *)
(* Author: Mark Hayden, 11/96 *)
(**************************************************************)

let rec ordered_help last = function
  | [] -> true
  | hd :: tl ->
      if hd > last then ordered_help hd tl else false

let ordered l =
  match l with
  | [] -> true
  | hd :: tl -> ordered_help hd tl

(**************************************************************)

let sort l =
  if ordered l then l
  else Sort.list (<) l

(**************************************************************)

let union l1 l2 =
  let l1 = sort l1 in
  let l2 = sort l2 in
  let rec loop l1 l2 =
    match l1,l2 with
    | [],l2 -> l2
    | l1,[] -> l1
    | (h1::t1),(h2::t2) ->
        if h1 < h2 then
	  h1 :: (loop t1 l2)
	else if h1 > h2 then 
	  h2 :: (loop l1 t2)
	else
	  h1 :: (loop t1 t2)
  in loop l1 l2

let intersect l1 l2 =
  let l1 = sort l1 in
  let l2 = sort l2 in
  let rec loop l1 l2 =
    match l1,l2 with
    | [],l2 -> []
    | l1,[] -> []
    | (h1::t1),(h2::t2) ->
	if h1 < h2 then
	  loop t1 l2
	else if h1 > h2 then
	  loop l1 t2
	else 
	  h1 :: (loop t1 t2)
  in loop l1 l2

let subtract l1 l2 =
  let l1 = sort l1 in
  let l2 = sort l2 in
  let rec loop l1 l2 =
    match l1,l2 with
    | [],l2 -> []
    | l1,[] -> l1
    | (h1::t1),(h2::t2) ->
	if h1 < h2 then
	  h1 :: (loop t1 l2)
	else if h1 > h2 then
	  loop l1 t2
	else
	  loop t1 t2
  in loop l1 l2

(**************************************************************)
(**************************************************************)
(**************************************************************)
(* Debugging versions of above functions.
 *)
(*
let subtract l1 l2 =
  let old_subtract f = function
    | [] -> f
    | e  ->
      	let rec loop = function
          | [] -> []
       	  | elem::l -> if List.mem elem e then loop l else elem :: loop l
      	in loop f
  in
  let ret = subtract l1 l2 in
  if ret <> (sort (old_subtract l1 l2)) then
    failwith "subtract:check" ;
  ret
  
let union l1 l2 =      
  let old_union l1 l2 =
    let rec loop = function
      | [] -> l2
      | a::l -> if List.mem a l2 then loop l else a :: loop l
    in loop l1
  in
  let ret = union l1 l2 in
  if ret <> (sort (old_union l1 l2)) then
    failwith "union:check" ;
  ret

let intersect l1 l2 =  
  let old_intersect l1 l2 =
    let rec loop = function
      | [] -> []
      | a::l -> if List.mem a l2 then a :: loop l else loop l
    in loop l1
  in
  let ret = intersect l1 l2 in
  if ret <> (sort (old_intersect l1 l2)) then
    failwith "union:check" ;
  ret
*)
(**************************************************************)
(**************************************************************)
(**************************************************************)

let super l1 l2 = subtract l2 l1 = []
let disjoint l1 l2 = intersect l1 l2 = []

let collapse l =
  let l = sort l in
  match l with
  | [] -> []
  | hd::tl ->
      let rec loop last = function
    	| [] -> [last]
    	| hd::tl -> 
	    if last = hd then loop last tl
	    else last :: loop hd tl
      in loop hd tl

(**************************************************************)
