(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* IQ_FAST.MLI *)
(* Author: Mark Hayden, 4/95 *)
(**************************************************************)
(*
               	    head       	read   	  tail
                   \/          \/        \/
     [][][][][][][][][][][][][][][][][][][][][][][]
     0<-- reset -->                      <---- unset ...

*)
(**************************************************************)

type 'a t

val empty		: 'a -> 'a -> 'a t
val head		: 'a t -> int
val tail		: 'a t -> int
val grow		: 'a t -> int -> unit
val advance_head	: 'a t -> int -> unit
val advance_head_gc	: 'a t -> int -> ('a -> unit) -> unit
val advance_tail	: 'a t -> int -> unit
val add			: 'a t -> 'a -> unit
val get                 : 'a t -> int -> 'a
val assign		: 'a t -> int -> 'a -> bool
val get_prefix		: 'a t -> (int -> 'a -> unit) -> unit
val list_of_iq		: 'a t -> (int * 'a) list
val list_of_iq_interval : 'a t -> (int * int) -> (int * 'a) list
val hole		: 'a t -> (int * int) option

val read		: 'a t -> int
val read_hole		: 'a t -> (int * int) option
val read_prefix		: 'a t -> ('a -> int -> unit) -> unit

val opt_check_update	: 'a t -> int -> bool
val opt_insert_check_doread : 'a t -> int -> 'a -> bool
val free                : 'a t -> ('a -> unit) -> unit

val check               : 'a t -> unit

(**************************************************************)
