(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* IOVECL.MLI: operations on arrays of Iovec's. *)
(* Author: Mark Hayden, 3/95 *)
(* Unless otherwise mentioned, these functions do not free
 * the reference counts of their arguments and iovecs
 * returned have all been correctly reference counted. *)
(**************************************************************)
open Trans
(**************************************************************)

type t = Iovec.t array

(**************************************************************)

(* Refcounting operations: these apply appropriate iovec
 * refcount operation to all member iovecs.
 *)

val free	: debug -> t -> unit
val ref	        : debug -> t -> unit
val check	: debug -> t -> unit

(**************************************************************)

(* Calculate total length of an array of iovecs.
 *)
val len 	: debug -> t -> len

(* Flatten an iovec array into a single iovec.  Copying only
 * occurs if the array has more than 2 iovecs in it.  
 *)
val flatten 	: debug -> t -> Iovec.t (* allocates *)

(* Fragment iovec array into an array of iovec arrays of
 * some maximum size.  No copying occurs.  The resulting
 * iovec arrays are at most the specified length.
 *)
val fragment    : debug -> len -> t -> t array

(* Remove any empty iovecs from the array.
 *)
val clean       : debug -> t -> t

(* Make a marshaller for arrays of iovecs.
 *)
val make_marsh  : debug -> (('a -> t) * (t -> 'a))

(* Print information about an array of iovecs.  For debugging
 *)
val print       : debug -> t -> unit

(* Flatten an iovec array into a string buffer.
 *)
val flatten_buf : debug -> t -> buf -> ofs -> len -> len

(**************************************************************)
