(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* HSYS.MLI *)
(* Author: Mark Hayden, 5/95 *)
(**************************************************************)

type buf = string
type ofs = int
type len = int
type port = int
type inet
type socket
type info

type iovec = buf * ofs * len

type handler =
  | Handler0 of (unit -> unit)
  | Handler1

type socket_option =
  | Nonblock
  | Reuse
  | Join of inet
  | Leave of inet
  | Multicast of bool
  | Sendbuf of int
  | Recvbuf of int

type manager

val accept : socket -> socket * inet * port
val bind : socket -> inet -> port -> unit
val close : socket -> unit
val connect : socket -> inet -> port -> unit
val deering_addr : int -> inet
val error : exn -> string
val open_process : string -> string -> (bool * string * string)
val gettimeofday : unit -> float
val gettimeofdaya : float array -> unit
val getlogin : unit -> string
val gethostname : unit -> string
val has_ip_multicast : unit -> bool
val inet_any : unit -> inet
val inet_of_string : string -> inet
val int_of_socket : socket -> int
val listen : socket -> int -> unit
val marshal : Obj.t -> buf -> ofs -> len -> len
val max_msg_len : unit -> int
val pop_int : string -> int -> int
val preprocess : socket -> (inet * port) array -> info
val push_int : buf -> int -> int -> unit
val read : socket -> buf -> int -> int -> int
val recv : socket -> buf -> int -> int -> int
val recvfrom : socket -> buf -> int -> int -> int * inet * port
val select : socket list -> socket list -> socket list -> float -> socket list * socket list * socket list 
val send : socket -> buf -> int -> int -> int
val sendopt : info -> buf -> int -> int -> unit
val sendvopt : info -> iovec array -> unit
val setsockopt : socket -> socket_option -> unit
val socket_dgram : unit -> socket
val socket_stream : unit -> socket
val static_string : len -> string
val static_string_free : string -> unit
val stdin : unit -> socket
val string_of_inet : inet -> string
val manager : (socket * handler) list -> len -> (int -> len -> unit) -> manager
val poll : manager -> buf -> ofs -> bool

(**************************************************************)
