(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* HANDLER.MLI: handler tables *)
(* Author: Mark Hayden, 12/95 *)
(**************************************************************)

(* This is now implemented using functors in order to
 * introduce specialized equality and hashing functions.
 *)

module type S = 
  sig
    type key
    type ('subkey,'data,'upcall) t

    val create 	: ('data array -> 'upcall) -> ('subkey,'data,'upcall) t
    val add 	: ('subkey,'data,'upcall) t -> key -> 'subkey -> 'data -> unit
    val remove 	: ('subkey,'data,'upcall) t -> key -> 'subkey -> unit
    val find 	: ('subkey,'data,'upcall) t -> key -> 'upcall
    val list_of : ('subkey,'data,'upcall) t -> (key * 'subkey) list
    val size 	: ('subkey,'data,'upcall) t -> int
    val info	: ('subkey,'data,'upcall) t -> string
  end

module Make(H: Hashtbl.S): (S with type key = H.key)
