(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(* Module [Fqueue]: functional first-in first-out queues *)

(* This module implements queues (FIFOs), without in-place modification. *)

type 'a t
        (* The type of queues containing elements of type ['a]. *)

exception Empty
        (* Raised when [take] is applied to an empty queue. *)

val empty: 'a t
        (* An empty queue. *)

val add: 'a -> 'a t -> 'a t
        (* [add x q] adds the element [x] at the end of the queue [q]. *)
val take: 'a t -> 'a * 'a t
        (* [take q] removes and returns the first element in queue [q],
           or raises [Empty] if the queue is empty. *)
val peek: 'a t -> 'a
        (* [peek q] returns the first element in queue [q], without removing
           it from the queue, or raises [Empty] if the queue is empty. *)
val length: 'a t -> int
        (* Return the number of elements in a queue. *)
val iter: ('a -> 'b) -> 'a t -> unit
        (* [iter f q] applies [f] in turn to all elements of [q],
           from the least recently entered to the most recently entered.
           The queue itself is unchanged. *)

val to_list : 'a t -> 'a list

val is_empty : 'a t -> bool
