(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
exception Empty

type 'a t = 
  { head : 'a list ;
    tail : 'a list }

let empty = { head = [] ; tail = [] }

let add x q = { head = q.head ; tail = x :: q.tail }

let is_empty q = 
  q.head = [] && q.tail = []

let take q =
  match q.head with
  | hd :: tl ->
      hd , { head = tl ; tail = q.tail }
  | [] ->
      match List.rev q.tail with
      |	hd :: tl -> hd, { head = tl ; tail = [] }
      |	[] -> raise Empty

let peek q =
  match q.head with
  | hd :: _ -> hd
  | [] ->
      if q.tail = [] then 
	raise Empty
      else 
	List.nth q.tail (pred (List.length q.tail))
  
let length q =
  List.length q.head + List.length q.tail

let iter f q =
  List.iter f q.head ;
  List.iter f (List.rev q.tail)

let to_list q =
  q.head @ List.rev q.tail
  
