(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* DEEPCOPY.ML *)
(* Author: Mark Hayden, 4/96 *)
(**************************************************************)
open Obj

(* These numbers taken from ocaml/byterun/mlvalues.h
 *)
let string_tag	 = 252
let closure_tag  = 250
let infix_tag    = 249
let abstract_tag = 251
let final_tag    = 255
let no_scan_tag  = 251

let rec f o =
  if not (is_block o) then o else (
    let tag = tag o in
    let size = size o in

    (* Don't allow deep copies of these kinds of objects.
     *)
    if tag = closure_tag
    || tag = infix_tag
    || tag = abstract_tag
    || tag = final_tag
    then invalid_arg "bad tag" ;

    if tag < no_scan_tag then (
      (* If structured object, then recurse on the fields.
       *)
      let n = new_block tag size in
      for i = 0 to pred size do
	set_field n i (f (field o i))
      done ;
      n
    ) else if tag = string_tag then (
      let o = (magic o : string) in
      let n = String.copy o in
      let n = (repr n) in
      n
    ) else (
      (* If flat, then use marshalling to copy it.  I don't
       * know any other good way to do this safely.
       *)
      let o = marshal o in
      let n,_ = unmarshal o 0 in
      n
    )
  )

let f =
  (fun o ->
    let o = Obj.repr o in
    let o = f o in
    let o = Obj.magic o in
    o : 'a -> 'a)
