(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* COMPRESS.MLI *)
(* Author: Mark Hayden, 4/97 *)
(**************************************************************)
open Trans
(**************************************************************)

type ('abv,'cps) t =
  | Full of 'abv * Iovecl.t
  | Compressed of 'cps * ('cps -> 'abv) * Iovecl.t
  | CompressedIovl of Iovecl.t
  | CompressedIov of Iovec.t
  | LostC
  | Unset				(* for iq *)
  | Reset				(* for iq *)

val uncompress : ('abv,'cps) t -> 'abv * Iovecl.t

val size : ('abv,'cps) t -> len
