(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* COMPRESS.ML *)
(* Author: Mark Hayden, 4/97 *)
(**************************************************************)
let name = Trace.source_file "COMPRESS"
(**************************************************************)

type ('abv,'cps) t =
  | Full of 'abv * Iovecl.t
  | Compressed of 'cps * ('cps -> 'abv) * Iovecl.t
  | CompressedIovl of Iovecl.t
  | CompressedIov of Iovec.t
  | LostC
  | Unset				(* for iq *)
  | Reset				(* for iq *)

(**************************************************************)
(* UNCOMPRESS: Items in the buffer can be compressed in
 * several ways to save space and time.  This function
 * uncompresses them.  
 *)
let uncompress = function
  | Full(abv,iov)        -> (abv,iov)
  | Compressed(m,f,iov)  -> (f m,iov)
(*
  | CompressedIov(iov)   -> (some_of s.normCastMsg,[|iov|])
  | CompressedIovl(iovl) -> (some_of s.normCastMsg,iovl)
*)
  | CompressedIov(iov)   -> failwith "uncompress:CompressedIov"
  | CompressedIovl(iovl) -> failwith "uncompress:CompressedIovl"
  | LostC                -> failwith "uncompress:Lost message"
  | Unset                -> failwith "uncompress:Unset(Iq prob)"
  | Reset                -> failwith "uncompress:Reset(Iq prob)"

(**************************************************************)

let size = function
  | Full        (_,iov) -> Iovecl.len name iov
  | Compressed(_,_,iov) -> Iovecl.len name iov
  | CompressedIovl(iov) -> Iovecl.len name iov
  | CompressedIov (iov) -> Iovec.len  name iov
  | LostC               -> 0
  | _ -> failwith "MNAK:size:sanity"

(**************************************************************)

