(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* ARRAYOP.ML *)
(* Author: Mark Hayden, 1/97 *)
(**************************************************************)

let maxify a1 a2 =
  if Array.length a1 <> Array.length a2 then
    failwith "maxify:mismatched arrays" ;
  for i = 0 to pred (Array.length a1) do
    a1.(i) <- max a1.(i) a2.(i)
  done	      

let minify a1 a2 =
  if Array.length a1 <> Array.length a2 then
    failwith "minify:mismatched arrays" ;
  for i = 0 to pred (Array.length a1) do
    a1.(i) <- min a1.(i) a2.(i)
  done	      

let mergify a1 a2 =
  if Array.length a1 <> Array.length a2 then
    failwith "mergify:mismatched arrays" ;
  for i = 0 to pred (Array.length a1) do
    a1.(i) <- a1.(i) || a2.(i)
  done	      

let fillify a v =
  Array.fill a 0 (Array.length a) v

let setify a1 a2 =
  if Array.length a1 <> Array.length a2 then
    failwith "setify:mismatched arrays" ;
  Array.blit a2 0 a1 0 (Array.length a1)
