(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* UNIQUE.MLI *)
(* Author: Mark Hayden, 8/96 *)
(**************************************************************)

(* Unique identifiers.
 *)
type id

(* Constructor.
 *)
val id : unit -> id

(* Display functions.
 *)
val string_of_id : id -> string
val string_of_id_short : id -> string
val string_of_id_realshort : id -> string

(* Hash an id.
 *)
val hash_of_id : id -> int

(* Are these from the same process?
 *)
val same_process : id -> id -> bool

(**************************************************************)
(* For transports.
 *)
val mux : id -> int			(* not for casual use *)
val install_port : int -> unit
(**************************************************************)
