(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* TYPEDESCR.MLI *)
(* Author: Robbert vanRenesse, 4/97 *)
(**************************************************************)

type type_constr =
  | CONST
  | NCCONST of t list

and t =
  | ABSTRACT
  | UNIT
  | BOOL of string
  | CHAR of string
  | INT of string
  | FLOAT of string
  | STRING of string
  | LIST of t
  | ARRAY of t
  | PRODUCT of t list
  | STRUCT of (string * t) list
  | CONSTR of (string * type_constr) list
  | FUNCTION of t list

val sprint_type : t -> string
val pretty_sprint : t -> 'a -> string

val abstract_t : t
val unit_t : t
val bool_t : t
val char_t : t
val int_t : t
val float_t : t
val string_t : t
val list_t : t -> t
val array_t : t -> t

