(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* TIME.MLI *)
(* Author: Mark Hayden, 8/96 *)
(**************************************************************)

type t

val invalid 	: t
val zero 	: t
val of_int	: int -> t
val to_string 	: t -> string

(* Hacks for performance. 
 *)
(*val of_float 	: float -> t*)
(*val to_float 	: t -> float*)
external of_float : float -> t = "%identity"
external to_float : t -> float = "%identity"

val add 	: t -> t -> t
val sub 	: t -> t -> t
val div		: t -> t -> t

module Ord : (Priq.OrderedType with type t = t)
