(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* TIME.ML *)
(* Author: Mark Hayden, 8/96 *)
(**************************************************************)
open Util

type t = float

let zero = 0.0
let invalid = -(1.0)
let to_string t = sprintf "%.3f" t
let of_int = float
let add a b = a +. b
let sub a b = a -. b
let div a b = a /. b

(*let of_float = Util.ident*)
(*let to_float = Util.ident*)
external of_float : float -> t = "%identity"
external to_float : t -> float = "%identity"

module Ord =
  struct
    type time = t
    type t = time
    let zero = zero
    external ge : float -> float -> bool = "%gefloat"
  end
