(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* STACK_ID.ML *)
(* Author: Mark Hayden, 3/96 *)
(**************************************************************)
let name = Trace.source_file "STACK_ID"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)

type t =
  | Primary
  | Bypass
  | Gossip
  | Unreliable

let mapping = [
  "Primary", Primary ;
  "Gossip", Gossip ;
  "Unreliable", Unreliable ;
  "Bypass", Bypass
] 

let id_of_string,string_of_id = Util.make_map name "id" mapping
