(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* SHARED *)
(* Author: Mark Hayden, 6/95 *)
(**************************************************************)
open Trans

type src = string
type dst = string
type context = string

(* The type of a shared key manager.
 *)
type t

(* Find the correct encryption mechanism to use for this
 * key.  This assumes that all members are using the same
 * set of encryption mechanisms.
 *)
val of_key : Security.key -> t

(* Create a new context from the key.
 *)
val init : t -> Security.key -> bool -> context

(* Encrypt/decrypt more data.  All the data must be aligned on
 * 8 bytes.  Arguments are as with String.blit, but instead of
 * copying the data, it also encrypts it.  I believe the source
 * and destination can overlap (but only if they overlap completely.
 *)
val update : t -> context -> buf -> ofs -> buf -> ofs -> len -> unit

(* Finalize the context.  This just involves wiping the bytes
 * clean.
 *)
val final : t -> context -> unit

(* Install a new encryption mechanism.
 *)
val install : (Security.key -> bool) -> 
  (Security.key -> bool -> context) ->	(* init *)
  (context -> src -> ofs -> dst -> ofs -> len -> unit) -> (* update *)
  (context -> unit) ->			(* final *)
  unit
