(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* SHARED *)
(* Author: Mark Hayden, 6/95 *)
(**************************************************************)
open Trans

type src = string
type dst = string
type context = string

type t = {
  init : Security.key -> bool -> context ;
  update : context -> src -> ofs -> dst -> ofs -> len -> unit ;
  final : context -> unit
} 

let init t = t.init
let update t = t.update
let final t = t.final

let table = ref []

let install ok init update final =
  let t = {
    init = init ;
    update = update ;
    final = final
  } in
  table := (ok,t) :: !table

let of_key key =
  let rec loop = function
    | [] -> failwith "no appropriate encryption available"
    | (ok,t)::tl ->
	if ok key then t else loop tl
  in loop !table  

