(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* SECURITY *)
(* Author: Mark Hayden, 6/95 *)
(**************************************************************)
open Printf

type key = 
  | NoKey
  | Common of string

let str_of_key k = 
  match k with 
  | NoKey -> raise (Failure "Key=NoKey")
  | Common(s) -> s
      
let string_of_key_short = function
  | NoKey -> "None"
  | Common key -> 
      let key = Digest.string key in
      let key = Util.hex_of_string key in
      let len = String.length key in
      let len = min 16 len in
      let key = String.sub key 0 len in
      sprintf "%s(sig)" key
      
let string_of_key = function
  | NoKey -> "{Key:None}"
  | Common key -> 
      let key = Digest.string key in
      let key = Util.hex_of_string key in
      sprintf "{Key:Shared:%s(sig)}" key
      
let sign key buf ofs len =
  let key = match key with
  | NoKey -> failwith "sign:NoKey"
  | Common s -> s
  in
  let sign = Digest.substring buf ofs len in
  let sign = sign ^ key in
  let sign = Digest.string sign in
(*
  let k = Hdes.key_of_string(key) in 
  Hdes.cbc sign 0 16 k true;
*)
  sign

let create () =
  let key = Hsys.gettimeofday () in
  let key = sprintf "%f" key in
  let key = Digest.string key in
  Common(key)

type md5_context = string

let md5_init () = ""
let md5_update c s = c ^ s
let md5_final c = Digest.string c

(* Make a short-lived nonce: e.g., t + 5 seconds
 *)
let make_nonce t = Time.add (Time.of_float 5.0) t
