(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* ROUTE.MLI *)
(* Author: Mark Hayden, 12/95 *)
(**************************************************************)
open Trans
(**************************************************************)

(* Type of routers.
 *)
type 'msg t = {
  name		: string ;
  secure	: bool ;
  blast 	: 
    (buf -> ofs -> len -> unit) ->	(* Xmit *)
    (Iovecl.t -> unit) ->		(* Xmit vect *)
    Security.key -> Conn.id -> 'msg ;
  install	: Conn.t -> Security.key -> (Conn.kind -> rank -> 'msg) -> unit ;
  remove	: Conn.t -> unit
}

(**************************************************************)

type message =
  | Signed of (Conn.kind * rank * (Conn.kind -> rank -> bool -> int -> Obj.t option -> Iovecl.t -> unit))
  | Unsigned of (int -> Obj.t option -> Iovecl.t -> unit)
  | Bypass of (int -> Iovec.t -> unit)
  | Raw of (Iovecl.t -> unit)
  | Scale of (rank -> int -> Obj.t option -> Iovecl.t -> unit)

val merge1f : ('a -> unit) array -> (('a -> unit) -> 'b) -> 'b
val merge1 : ('a -> unit) array -> 'a -> unit
val merge2 : ('a -> 'b -> unit) array -> 'a -> 'b -> unit
val merge2f : ('a -> 'b -> unit) array -> (('a -> 'b -> unit) -> 'c) -> 'c
val merge3 : ('a -> 'b -> 'c -> unit) array -> 'a -> 'b -> 'c -> unit
val merge3f : ('a -> 'b -> 'c -> unit) array -> (('a -> 'b -> 'c -> unit) -> 'd) -> 'd
val merge4 : ('a -> 'b -> 'c -> 'd -> unit) array -> 'a -> 'b -> 'c -> 'd -> unit

type merge = (Conn.id * Security.key * Conn.kind * rank * message) array -> (Iovec.t -> unit)

val deliver : int -> Iovec.rbuf -> ofs -> len -> unit

val drop : (unit -> string) -> unit (* For tracing message drops: ROUTED *)
val info : (unit -> string) -> unit (* For tracing connection ids: ROUTEI *)


val make :
  debug -> 
  ((Conn.id * Conn.kind * rank * debug) list -> 
    (Conn.id * Conn.kind * rank * debug) list) ->
  ((Conn.kind -> rank -> 'msg) -> Conn.kind -> rank -> message) ->
  (Conn.id -> Digest.t) ->		(* packer *)
  ((Conn.id * Digest.t * Security.key * message) array -> 
   (Iovec.rbuf -> ofs -> len -> unit)) -> (* merge *)
  ((buf -> ofs -> len -> unit) -> (Iovecl.t -> unit) ->	Security.key -> Digest.t -> Conn.id -> 'msg) ->  (* blast *)
  'msg t

(**************************************************************)
