(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* PROPERTY.MLI *)
(* Author: Mark Hayden, 12/96 *)
(**************************************************************)

type id =
  | Agree				(* agreed (safe) delivery *)
  | Gmp					(* group-membership properties *)
  | Sync				(* view synchronization *)
  | Total				(* totally ordered messages *)
  | Heal				(* partition healing *)
  | Switch				(* protocol switching *)
  | Auth				(* authentication *)
  | Causal				(* causally ordered broadcasts *)
  | Subcast				(* subcast pt2pt messages *)
  | Frag				(* fragmentation-reassembly *)
  | Debug				(* adds debugging layers *)
  | Scale				(* scalability *)
  | Xfer				(* state transfer *)
  | Cltsvr				(* client-server management *)
  | Suspect				(* failure detection *)
  | Evs					(* extended virtual synchrony *)
  | Flow				(* flow control *)
  | Migrate				(* process migration *)
  | Privacy				(* encryption of application data *)
  | Rekey				(* support for rekeying the group *)
  | Primary				(* primary partition detection *)

    (* The following are not normally used.
     *)
  | Control				(* attach control panel *)
  | Drop				(* randomized message dropping *)
  | Pbcast				(* Hack: just use pbcast prot. *)

(* Create protocol with desired properties.
 *)
val choose : id list -> Proto.id

(* Common property lists.
 *)
val vsync : id list			(* Fifo virtual synchrony *)
val causal : id list			(* vsync + Causal *)
val total : id list			(* vsync + Total *)
val scale : id list			(* vsync + Scale *)
val fifo : id list			(* only Fifo (no membership) *)
val transis : id list			(* full Transis protocols *)

val string_of_id : id -> string
val id_of_string : string -> id
val all : id list

(**************************************************************)

(* Strip unnecessary properties for use of groupd.
 *)
val strip_groupd : id list -> id list

(**************************************************************)
