(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* PARAM.MLI *)
(* Author: Mark Hayden, 12/96 *)
(**************************************************************)
open Trans
(**************************************************************)

type t =
  | String of string
  | Int of int
  | Bool of bool
  | Time of Time.t
  | Float of float

type tl = (name * t) list

val default : name -> t -> unit
val print_defaults : unit -> unit
val lookup : tl -> name -> t
val string : tl -> name -> string
val int : tl -> name -> int
val bool : tl -> name -> bool
val time : tl -> name -> Time.t
val float : tl -> name -> float
