(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* PARAM.ML *)
(* Author: Mark Hayden, 12/96 *)
(**************************************************************)
open Util
open Trans
(**************************************************************)
let name = "PARAM"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)

type t =
  | String of string
  | Int of int
  | Bool of bool
  | Time of Time.t
  | Float of float

type tl = (name * t) list

let defaults = ref []

let default name t =
  defaults := (name,t) :: !defaults

let print_defaults () =
  eprintf "PARAM:default values:begin\n" ;
  List.iter (fun (name,t) ->
    eprintf "  %s=" name ;
    match t with
    | String v -> eprintf "String(%s)\n" v
    | Int v -> eprintf "Int(%d)\n" v
    | Bool v -> eprintf "Bool(%b)\n" v
    | Time v -> eprintf "Time(%s)\n" (Time.to_string v)
    | Float v -> eprintf "Float(%f)\n" v
  ) !defaults ;
  eprintf "PARAM:default values:end\n"

let lookup l name =
  try List.assoc name l with Not_found ->
    try List.assoc name !defaults with Not_found ->
      eprintf "PARAM:lookup:%s\n" name ;
      failwith "lookup failed"

let string tl name =
  match lookup tl name with
  | String s -> s
  | _ -> failwith "string"

let time tl name =
  match lookup tl name with
  | Time s -> s
  | _ -> failwith "time"

let int tl name =
  match lookup tl name with
  | Int s -> s
  | _ -> failwith "int"

let bool tl name =
  match lookup tl name with
  | Bool s -> s
  | _ -> failwith "bool"

let float tl name =
  match lookup tl name with
  | Float s -> s
  | _ -> failwith "float"
