(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* LAYER.MLI *)
(* Author: Mark Hayden, 4/95 *)
(**************************************************************)
open Trans
(**************************************************************)

type 'a saved = 'a option ref

(**************************************************************)

type ('a,'b,'c) handlers_out = {
  up_out	: Event.up -> 'c -> unit ;
  upnm_out	: Event.up -> unit ;
  dn_out 	: Event.dn -> 'c -> 'b -> unit ;
  dnlm_out	: Event.dn -> 'a -> unit ;
  dnnm_out	: Event.dn -> unit
}

type ('a,'b,'c) handlers_in = {
  up_in 	: Event.up -> 'c -> 'b -> unit ;
  uplm_in 	: Event.up -> 'a -> unit ;
  upnm_in 	: Event.up -> unit ;	
  dn_in 	: Event.dn -> 'c -> unit ;
  dnnm_in 	: Event.dn -> unit
}

type ('local,'hdr,'abv) full =
  ('local,'hdr,'abv) handlers_out ->
  ('local,'hdr,'abv) handlers_in

(**************************************************************)
(* What messages look like in this architecture.
 *)
type ('local,'hdr,'abv) msg =
  | NoMsg
  | Local of 'local
  | Full of 'hdr * 'abv
  | Full_nohdr of 'abv
  | Local_nohdr
  | Local_seqno of Trans.seqno

(**************************************************************)

type ('local,'hdr) optimize =
  | NoOpt
  | LocalNoHdr of 'local
  | FullNoHdr of 'hdr
  | LocalSeqno of 'hdr * Event.typ * ('hdr -> Trans.seqno option) * (Trans.seqno -> 'hdr)

(**************************************************************)
(* Message composition functions (for bypass code).
 *)
val compose_msg : 'abv -> 'hdr -> ('local,'hdr,'abv) msg
val local_msg : 'local -> ('local,'hdr,'abv) msg
val no_msg : unit -> ('local,'hdr,'abv) msg

(**************************************************************)
(* Type of exported layers. (Exported for bypass code.)
 *)

type ('bel,'abv) handlers_lout = {
  up_lout	: Event.up -> 'bel -> unit ;
  dn_lout 	: Event.dn -> 'abv -> unit
}

type ('bel,'abv) handlers_lin  = {
  up_lin 	: Event.up -> 'abv -> unit ;
  dn_lin 	: Event.dn -> 'bel -> unit
}

type ('bel,'abv,'state) basic =
  View.full -> 'state * (('bel,'abv) handlers_lout -> ('bel,'abv) handlers_lin)

(**************************************************************)
(* Alias for common layers in this architecture.
 *)

type ('local,'hdr,'state,'abv1,'abv2,'abv3) t = 
  (('abv1,'abv2,'abv3) msg, ('local,'hdr,('abv1,'abv2,'abv3)msg) msg,'state) basic

val hdr_state :
  ('args -> View.full -> 'state) ->
  ('state -> View.full -> ('local,'hdr,('abv1,'abv2,'abv3)msg) full) ->
  Typedescr.t option ->
  ('local,'hdr) optimize ->
  'args -> ('local,'hdr,'state,'abv1,'abv2,'abv3) t

val hdr :
  ('args -> View.full -> 'state) ->
  ('state -> View.full -> ('local,'hdr,('abv1,'abv2,'abv3)msg) full) ->
  Typedescr.t option ->
  ('local,'hdr) optimize ->
  'args -> ('local,'hdr,unit,'abv1,'abv2,'abv3) t

(**************************************************************)

type state = {
  interface     : Appl_intf.t ;
  switch	: Time.t saved
}

val new_state : Appl_intf.t -> state

val reset_state : state -> unit

(**************************************************************)

type ('args,'b,'c,'d) init = 
  ('args -> ('b ,'c ,'d) basic) -> 
  state -> (unit,unit,unit) basic

val init: (unit,'a,'b,'c) init
val initSwitch : (Time.t saved,'a,'b,'c) init
val initTop_appl : (Appl_intf.t,'a,'b,'c) init
val initNamed : (name,'a,'b,'c) init 

(**************************************************************)

val look_again : 
  name -> 
  state -> ('a,'b,'c) basic

val install :
  name -> 
  (state -> (unit,unit,unit) basic) ->
  unit

val finder : 
  string -> 
  (name -> state -> (unit,unit,unit) basic) -> 
  unit

val procure_hide : 
  name -> state -> ('a,'b,'c) basic

(**************************************************************)
(* Dynamic linking code.
open Procure
open Util
open Dynlink

let inited = ref false

let find name =
  if not !inited then (
    inited := true ;
    Dynlink.init () ;
    add_available_units Link_config.crc_unit_list
  ) ;

  printf "LINK:dynamically linking %s\n" name ;
  begin try
    loadfile (
      Link_config.objpath ^
      name ^ "." ^
      Link_config.objsuff
    )
  with Dynlink.Error e ->
    printf "LINK:dynlink error:%s\n" (error_message e) ;
    raise Not_found
  end ;
  look_again name

let _ =
  finder "DynamicLink" find
*)
(**************************************************************)
