(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* HANDLE.ML *)
(* Authors: Mark Hayden, Jason Hickey, 7/95 *)
(**************************************************************)

module Wrap = struct
  type 'a t = 'a ref option

  let create a =
    ref (Some a)

  let disable w =
    w := None
end

type 'a t = {
    obj : 'a ;
    mutable alive : bool ;
    mutable wrapped : (unit -> unit) Wrap.t
  } 

(* WRAP: use a handle to wrap an object.
 * When the handle is disabled, so will the object.
 *)
let wrap h a =
  let w = Wrap.create a in
  let disable () = Wrap.disable w in
  h.wrapped := disable :: h.wrapped


let wrapf h a f =
  let w = Wrap.create a in
  let disable () = 
    Wrap.disable w ;
    f a
  in
  h.wrapped := disable :: h.wrapped
  

let disable h =
  if not h.alive then
    failwith "disabled twice" ;
  h.alive <- false ;
  List.iter (fun f -> f ()) h.wrapped ;
  h.wrapped <- [] ;

    
