(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* GROUP.ML *)
(* Author: Mark Hayden, 4/96 *)
(**************************************************************)
let name = Trace.source_file "GROUP"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)
open Util
(**************************************************************)

type id	= 
  | Anon of Unique.id			(* anonymous groups *)
  | Named of string			(* named groups *)

let id () = Anon (Unique.id ())
let named name = Named name

let string_of_id = function
  | Named name -> sprintf "{Group:Named:%s}" name
  | Anon id    -> sprintf "{Group:Anon:%s}" (Unique.string_of_id_short id)

let hash_of_id = function
  | Named name -> Hashtbl.hash (Digest.string name)
  | Anon id -> Unique.hash_of_id id

(**************************************************************)
