(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* ENDPT.MLI *)
(* Author: Mark Hayden, 7/95 *)
(**************************************************************)
open Trans
(**************************************************************)

(* Type of endpoints.
 *)
type id

type full = id * Addr.set

(* Constructors.  The named endpoints are only used for
 * debugging purposes.  Named endpoints (as opposed to named
 * groups which just have a string) still contain a unique
 * identifier along with the name.  
 *)
val id		        : unit -> id	(* anonymous endpoints *)
val named               : debug -> id	(* named endpoints *)

(* Display functions.
 *)
val string_of_id	: id -> string
val string_of_full      : full -> string

val string_of_id_list	: id list -> string

(**************************************************************)
val short_strings       : unit -> unit
(**************************************************************)
