(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* ENDPT.ML *)
(* Author: Mark Hayden, 7/95 *)
(**************************************************************)
open Trans
open Util
(**************************************************************)
let name = Trace.source_file "ENDPT"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)

type id	= 
  | Anon of Unique.id			(* anonymous endpoints *)
  | Named of debug * Unique.id		(* named endpoints *)

type full = id * Addr.set

let id () = Anon (Unique.id ())
let named debug = Named(debug,Unique.id())

let long = ref true

let string_of_id id =
  match id with
  | Anon id -> 
      if !long then (
      	sprintf "{Endpt:%s}" (Unique.string_of_id_short id)
      ) else (
    	sprintf "{Ept:%s}" (Unique.string_of_id_realshort id)
      )
  | Named(debug,id) ->
      sprintf "{Endpt:%s:%s}" debug (Unique.string_of_id_short id)

let string_of_full =
  string_of_pair string_of_id Addr.string_of_set

let string_of_id_list = 
  Util.string_of_list string_of_id

let short_strings () =
  long := false

(**************************************************************)
