(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* CONN.MLI : communication connection ids *)
(* Author: Mark Hayden, 12/95 *)
(**************************************************************)

(* Identifier used for communication routing.
 *)
type id

type kind = Cast | Send | Other

(* Set of connection identifiers used to communicate
 * with peers.
 *)
type id_field = Version.id * Endpt.id * Group.id * View.id * Stack_id.t * Proto.id
type t = {
  id	     	: id_field ;

  pt2pt_send 	: id array ;
  pt2pt_recv	: id array ;

  multi_send 	: id ;
  multi_recv	: id array ;

  merge_send 	: View.id option -> Endpt.id -> id ;
  merge_recv	: id ;

  gossip 	: id ;

  all_recv 	: (id * kind * Trans.rank * string(*dbg*)) list
}

val string_of_t : t -> string
val string_of_id_field : id_field -> string

(* Constructor.
 *)
val create : 
  Version.id ->
  Endpt.id -> 
  Group.id -> 
  View.id -> 
  Stack_id.t -> 
  Proto.id -> 
  View.t -> 
  bool ->				(* gossip only? *)
  t

(* Display functions.
 *)
val string_of_id : id -> string

val string_of_kind : kind -> string

(**************************************************************)
(* Create a 16-byte MD5 hash of an id.
 *)
val hash_of_id : id -> string

(* A hack.  Squashes sender field in id to value to an
 * illegal value.  and return the original field.  Used
 * in Router.scale.
 *)
val squash_sender : id -> (Trans.rank option * id)

(**************************************************************)
