(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* AUTH.MLI *)
(* Authors: Mark Hayden, Ohad Rodeh, 8/96 *)
(**************************************************************)
(* This file gives a generic interface to authentication
 * services. *)
(**************************************************************)
open Trans

type t

type clear = string			(* cleartext *)
type cipher = string			(* ciphertext *)

val lookup : Addr.id -> t

val principal : t -> Addr.id -> string -> Addr.t
val seal      : t -> Addr.id -> Addr.set -> Addr.set -> clear -> cipher option
val unseal    : t -> Addr.id -> Addr.set -> Addr.set -> cipher -> clear option

(**************************************************************)

type ticket

val ticket : Addr.set(*me*) -> Addr.set(*him*) -> clear -> ticket option

val check : Addr.set(*me*) -> ticket -> clear option

(**************************************************************)

val create : 
  name ->
  (Addr.id -> string -> Addr.t) ->
  (Addr.id -> Addr.set -> Addr.set -> clear -> cipher option) ->
  (Addr.id -> Addr.set -> Addr.set -> cipher -> clear option) ->
  t

val install : Addr.id -> t -> unit

(**************************************************************)
