(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* ALARM.MLI *)
(* Author: Mark Hayden, 4/96 *)
(**************************************************************)
open Trans
open Hsys
(**************************************************************)

(* ALARM.ID: Each of the known alarms has an associated
 * identifier.
 *)
type id =
  | Netsim
  | Real
  | Tk
  | Threaded

(* Conversion functions.
 *)
val id_of_string : string -> id
val string_of_id : id -> string

(**************************************************************)

(* ALARM: a record for requesting timeouts on a particular
 * callback.  
 *)
type alarm

val disable : alarm -> unit
val schedule : alarm -> Time.t -> unit

(**************************************************************)

(* ALARM.T: The type of alarms.
 *)
type t

(**************************************************************)

type poll_type = SocksPolls | OnlyPolls

val name	: t -> string
val gettime 	: t -> Time.t
val alarm 	: t -> (Time.t -> unit) -> alarm
val check 	: t -> bool
val min 	: t -> Time.t
val add_sock 	: t -> socket -> handler -> unit
val rmv_sock 	: t -> socket -> unit
val add_poll 	: t -> string -> (bool -> bool) -> unit
val rmv_poll 	: t -> string -> unit
val block 	: t -> unit
val poll 	: t -> poll_type -> bool

(**************************************************************)
(* Manage alarm tables.
 *)

val install	: id -> (Sched.t -> t) -> unit
val choose 	: id -> Sched.t -> unit
val get	        : unit -> t

(**************************************************************)
(**************************************************************)
(* For use only by alarms.
 *)

val create :
  string ->				(* name *)
  (unit -> Time.t) ->			(* gettime *)	
  ((Time.t -> unit) -> alarm) ->	(* alarm *)	      
  (unit -> bool) ->			(* check *)
  (unit -> Time.t) ->			(* min *)
  (socket -> handler -> unit) ->	(* add_sock *)	
  (socket -> unit) ->			(* rmv_sock *)
  (unit -> unit) ->			(* block *)
  (string -> (bool -> bool) -> unit) ->	(* add_poll *)	
  (string -> unit) ->			(* rmv_poll *)
  (poll_type -> bool) ->		(* poll	*)
  t

val alm_poll		: bool -> bool
val alm_add_poll	: string -> (bool -> bool) -> unit
val alm_rmv_poll	: string -> unit

val wrap : ((Time.t -> unit) -> Time.t -> unit) -> t -> t
val c_alarm : (unit -> unit) -> (Time.t -> unit) -> alarm
(**************************************************************)
