(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* ADDR.MLI *)
(* Author: Mark Hayden, 12/95 *)
(**************************************************************)
open Trans

(* Address ids.
 *)
type id =
  | Atm
  | Deering
  | Netsim
  | Tcp
  | Udp
  | Sp2
  | Krb5
  | Pgp
  | Fortezza

(* Addresses.
 *)
type t =
  | AtmA of inet
  | DeeringA of inet * port
  | NetsimA
  | TcpA of inet * port
  | UdpA of inet * port
  | Sp2A of inet * port
  | Krb5A of string
  | PgpA of string
  | FortezzaA of string

(* Processes actually use collections of addresses.
 *)
type set

(* Display functions.
 *)
val string_of_id : id -> string
val string_of_id_short : id -> string	(* just first char *)
val string_of_addr : t -> string
val string_of_set : set -> string

(* Conversion functions.
 *)
val set_of_array : t array -> set
val array_of_set : set -> t array
val id_of_addr : t -> id
val id_of_string : string -> id
val ids_of_set : set -> id array
val project : set -> id -> t

(* Info about ids.
 *)
val has_mcast : id -> bool
val has_pt2pt : id -> bool
val has_auth : id -> bool

(* Sets of addresses are on the same process if any of the 
 * addresses are the same.  (Is this correct?)
 *)
val same_process : set -> set -> bool

(* Remove duplicated destinations.  [compress my_addr
 * addresses] returns tuple with whether any elements of the
 * view were on the same process and a list of addresses with
 * distinct processes.  
 *)
val compress : set -> set array -> bool * set array

(* Choose "best" mode to use.
 *)
val prefer : id array -> id

(* Explain problem with these modes.
 *)
val error : id array -> unit

val modes_of_view : set array -> id array
