(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* REAL.ML *)
(* Author: Mark Hayden, 3/96 *)
(**************************************************************)
open Util
(**************************************************************)
let name = Trace.source_file "REAL"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)
let ts_recv = Timestamp.add "UDP:recv"
(**************************************************************)

let blocker = ref None

let install_blocker f =
  blocker := Some(f)

(*
module Priq = Priq.Make ( Time.Ord )
*)

let alarm sched =
  let deliver = Route.deliver in
  let deliver = 
    if Timestamp.check "recv" then (
      let deliver i b o l =
	ts_recv () ;
    	deliver i b o l
      in deliver
    ) else deliver
  in

  let block = ref (fun _ () -> false) in
  let poll = ref (fun () -> false) in

  let update l =
    if Arge.get Arge.multiread then (
      let deliver i b o l =
	Sched.enqueue_4arg sched Route.deliver i b o l
      in
      let blockf time =
 	let block = Hsyssupp.block Mbuf.global deliver l time in
	fun () ->
	  while block () do () done ;
	  
	  (* We can return false here because the event scheduler
	   * will have stuff to schedule and so it will return
	   * true.
	   *)
	  false
      in
      block := blockf ;
      poll := blockf (Time.to_float Time.zero) ;
    ) else (
      block := Hsyssupp.block Mbuf.global deliver l ;
      poll := !block (Time.to_float Time.zero) ;
    )
  in 
  
(*
  let ts_recv = Timestamp.add "REAL:recv" in
*)
  let alarms  = Priq.create Time.zero in

  let socks = 
    Resource.create "REAL:socks"
    (fun _ _ -> ())
    (fun _ -> ())
    (fun socks ->
      let l1 = Resource.to_list socks in
      let l2 = Resource.to_list2 socks in
      update (List.combine l1 l2) ;
    )
  in

  Trace.install_root (fun () ->
    [sprintf "REAL:%s\n" (Resource.info socks)]
  ) ;

  let block () =
    let timeout =
      if Priq.size alarms = 0 then
      	-1.0
      else (
        let time = Hsys.gettimeofday () in
        let next = Time.to_float (Priq.min alarms) in
	if next < time then 
      	  zero
	else 
      	  next -. time
      )
    in
    match !blocker with
    | None ->
    	!block timeout () ; 
	()
    | Some f -> f timeout
  in

  let space = [|0.0|] in

  let gettime () = Time.of_float (Hsys.gettimeofday ())

  and min () = Priq.min alarms

  and check () =
    Hsys.gettimeofdaya space ;
    let time = space.(0) in
    let time = Time.of_float time in
    if Time.Ord.ge time (Priq.min alarms) then
      Priq.getopt alarms time
    else
      false

  and alarm callback =
    let disable () = () in
    let schedule time =
(*
      eprintf "REAL:Priq.size alarms = %d\n" (Priq.size alarms) ;
*)
      Priq.add alarms time callback
    in Alarm.c_alarm disable schedule

  and poll = 
    function
    | Alarm.SocksPolls -> Alarm.alm_poll false || (!poll ())
    | Alarm.OnlyPolls -> Alarm.alm_poll false

  and add_sock = Resource.add socks
  and rmv_sock = Resource.remove socks
  and add_poll = Alarm.alm_add_poll
  and rmv_poll = Alarm.alm_rmv_poll

  in Alarm.create
    "REAL"
    gettime
    alarm
    check
    min
    add_sock
    rmv_sock
    block
    add_poll
    rmv_poll
    poll

let _ =
  Alarm.install Alarm.Real alarm

(**************************************************************)
