(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
open Mkutil
open Printf

let path = ref []

let proc_file file =
(*
  let file =
    try find_path !path file with Not_found ->
      exit 0
  in
*)

  let modul = Filename.basename file in
  let modul = Filename.chop_extension modul in
  let modul = String.capitalize modul in

  printf "module %s : sig\n" modul ;

  let ch = open_in file in
  let lines = read_lines ch in
  List.iter (fun line ->
    printf "  %s\n" line
  ) lines ;
  
  printf "end\n\n" ;

  flush stdout

let run () =
  Arg.parse [
    "-I",Arg.String(fun s -> path := s :: !path),": add dir to path"
  ] proc_file "hello" ;
  ()

let _ = run ()
