(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* ECP.ML *)
(* Author: Mark Hayden, 12/96 *)
(**************************************************************)
open Printf
open Mkutil

let dest = ref None
let nocmi = ref false
let nocmo = ref false

let install srcfile =
  let srcdir  = Filename.dirname srcfile in
  let srcbase = Filename.basename srcfile in
  let srcchop = srcbase in
  let oc_ext = match !nocmi, !nocmo with
  | false,false -> oc_ext
  | true, false -> oc_extnocmi
  | true, true  -> oc_extnocmicmo
  | _,_ -> failwith "sanity"
  in      

  match !dest with
  | None -> failwith "no destination directory"
  | Some dest ->
      List.iter (fun ext ->
      	let ext = plat_ext ext in
        let src = Filename.concat srcdir (srcchop ^ ext) in
      	let dst = (dest ^ ext) in
	if Sys.file_exists src then (
	  if !verbose then (
	    eprintf "ecp: %s -> %s\n" src dst ;
	    flush stderr
	  ) ;
	  if Sys.file_exists dst then
	    Sys.remove dst ;
	  copy src dst
        )
      ) oc_ext

let main () =
  try
    Arg.parse [
      "-o", 	       Arg.String(fun dir -> dest := Some dir),"";
      "-nocmi",        Arg.Set nocmi, "" ;
      "-nocmo",        Arg.Set nocmo, "" ;
      "-verbose",      Arg.Set verbose ,"";
      "-plat",         Arg.String(fun s -> plat := "-"^s),""
    ]	
      (fun file -> install file)
      ""
  with x -> raise x

let _ = 
  Printexc.catch main () ;
  exit 0
