/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
/**************************************************************/
#include <assert.h>
#include <sys/types.h>
#include "skt.h"
/**************************************************************/

#ifdef HAS_SOCKETS

/**************************************************************/

/* Set size of send buffers.
 */
value skt_setsock_sendbuf(	/* ML */
	value sock_v,
	value size_v
) {
  int size = Int_val(size_v) ;
  int sock = Int_val(sock_v) ;
  int ret ;

  ret = setsockopt(sock, SOL_SOCKET, SO_SNDBUF, (void*)&size, sizeof(size)) ;
  if (ret < 0) uerror("setsockopt:sendbuf", Nothing) ;

  return Val_int(ret) ;
}

/**************************************************************/

/* Set size of receive buffers.
 */
value skt_setsock_recvbuf(	/* ML */
	value sock_v,
	value size_v
) {
  int size = Int_val(size_v) ;
  int sock = Int_val(sock_v) ;
  int ret ;

  ret = setsockopt(sock, SOL_SOCKET, SO_RCVBUF, (void*)&size, sizeof(size)) ;
  if (ret < 0) uerror("setsockopt:recvbuf", Nothing) ;

  return Val_int(ret) ;
}

/**************************************************************/

#else /* HAS_SOCKETS */

value skt_setsock_sendbuf() { invalid_argument("setsock_sendbuf not implemented"); }
value skt_setsock_recvbuf() { invalid_argument("setsock_recvbuf not implemented"); }

#endif /* HAS_SOCKETS */

/**************************************************************/
