/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
#include <mlvalues.h>
#include "skt.h"

#ifndef _WIN32

value skt_socket_of_fd(value fd) { /* ML */
  return fd ;
}

#else
#include <windows.h>

value skt_socket_of_fd(value fd) { /* ML */
  HANDLE h;
  h = (HANDLE) _get_osfhandle(Int_val(fd)) ;
  if (h == (HANDLE) -1) {
    _dosmaperr(GetLastError());
    uerror("socket_of_fd", Nothing);
  }
  return Val_int((int)h);
}

#endif
