/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*								       */
/*  Extracted from the Unix library and made usable for the Winsock    */
/*  library by Robbert van Renesse at Cornell University.              */
/*                                                                     */
/***********************************************************************/

/* $Id: skt.h,v 1.6 1997/05/25 15:41:22 hayden Exp $ */

#include <errno.h>
#ifndef _WIN32
#define h_errno errno
#else
#include <winsock.h>
#endif

#include <string.h>
#include "config.h"		/* from $(LIBDIR)/caml */
#include "mlvalues.h"		/* from $(LIBDIR)/caml */
#include "misc.h"		/* from $(LIBDIR)/caml */
#include "alloc.h"		/* from $(LIBDIR)/caml */
#include "memory.h"		/* from $(LIBDIR)/caml */
#include "callback.h"		/* from $(LIBDIR)/caml */

/**************************************************************/
/*#define SKTTRACE printf("SOCKET:%s()\n",__FUNCTION__)*/
#define SKTTRACE do {} while(0)
/**************************************************************/

enum manager_fields {
  MAN_SOCKS,
  MAN_HANDLERS,
  MAN_MAX_LEN,
  MAN_HANDLER,
} ;

enum iovec_fields {
  IOV_BUF,
  IOV_OFS,
  IOV_LEN,
} ;

/**************************************************************/

#ifdef HAS_UNISTD
#include <unistd.h>
#endif

#ifdef HAS_ARPA_INET
#include <arpa/inet.h>
#endif

#define Nothing ((value) 0)

#include <stdio.h>

extern void unix_error P((int errcode, char * cmdname, value arg));
extern void uerror P((char * cmdname, value arg));
extern value unix_freeze_buffer P((value));

/* Begin: from minor_gc.h */
extern char *young_start, *young_ptr, *young_end, *young_limit;
#define Is_young(val) \
  ((addr)(val) > (addr)young_start && (addr)(val) < (addr)young_end)
extern void minor_collection P((void));
/* End: from minor_gc.h */

/* From fail.h */
void invalid_argument P((char *)) Noreturn;
void mlraise P((value bucket)) Noreturn;
mlsize_t string_length P((value));

/* From signals.h */
#ifndef _signals_
#define _signals_

void enter_blocking_section P((void));
void leave_blocking_section P((void));
void urge_major_slice P((void));

extern void (*enter_blocking_section_hook)();
extern void (*leave_blocking_section_hook)();

#endif /* _signals_ */



#ifdef HAS_SOCKETS
#include <sys/types.h>

#ifndef _WIN32
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#endif

union {
  struct sockaddr s_gen;
#ifndef _WIN32
  struct sockaddr_un s_unix;
#endif
  struct sockaddr_in s_inet;
} sock_addr;

int sock_addr_len;

void skt_get_sockaddr P((value));
value skt_alloc_sockaddr P((void));
value skt_alloc_inet_addr P((unsigned int));

#define GET_INET_ADDR(v) (*((uint32 *) (v)))

#define MSG_UNKNOWN_FLAG	0x20000000
#define MSG_SAFE		0x10000000

extern int msg_flag_table[4] ;
#endif /* HAS_SOCKETS */
