/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*								       */
/*  Extracted from the Unix library and made usable for the Winsock    */
/*  library by Mark Hayden at Cornell University.                      */
/*                                                                     */
/*                                                                     */
/***********************************************************************/

/* $Id: sendrecv.c,v 1.1 1997/04/29 14:51:30 hayden Exp $ */

#include "skt.h"

#if defined(HAS_SOCKETS)

value skt_recv(sock, buff, ofs, len) /* ML */
     value sock, buff, ofs, len;
{
  int ret;
  SKTTRACE;
  ret = recv(Int_val(sock), &Byte(buff, Long_val(ofs)), Int_val(len),0) ;
  if (ret == -1) uerror("recv", Nothing);
  return Val_int(ret);
}

value skt_send(sock, buff, ofs, len) /* ML */
     value sock, buff, ofs, len;
{
  int ret;
  SKTTRACE;
  ret = send(Int_val(sock), &Byte(buff, Long_val(ofs)), Int_val(len),0) ;
  if (ret == -1) uerror("send", Nothing);
  return Val_int(ret);
}

#else

value unix_recv() { invalid_argument("recv not implemented"); }

value unix_send() { invalid_argument("send not implemented"); }

#endif
