/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <sys/types.h>

#include "skt.h"

#ifdef HAS_SOCKETS

#ifdef BIG_ENDIAN		/* for SP2 */
#undef BIG_ENDIAN
#endif

#ifdef HAS_SENDMSG
#include <sys/uio.h>
#endif

#ifdef SKT_PROTO
#ifdef HAS_SENDMSG
extern int sendmsg(int s, struct msghdr *msg, int flags) ;
#endif
extern int sendto(int s, char *msg, int len, int flags, struct sockaddr *to, int tolen) ;
extern char *memset(char *s, int c, int n) ;
extern bcopy(char *b1,char *b2, int len) ;
#endif

typedef struct {
  int sock ;
  int flags ;
  int naddr ;
  int salen ;
  struct sockaddr sa[0];
} skt_msg ;

/* Adapted from mlvalues.h */
#define Wosize_bosize(sz) ((sz) / sizeof (value))

void get_sockaddr(value);	/* from ocaml/otherlibs/unix/sockaddr.h */

value skt_preprocess(
	value sock_v,
	value flags_v,		/* ignored */
	value sina_v
) {
  skt_msg *msg ;
  value msg_v ;
  int sock ;
  int flags ;
  int size ;
  int naddr ;
  int i ;

  Push_roots(roots,1) ;
  roots[0] = sina_v ;
#define sina_v roots[0]
  sock = Int_val(sock_v) ;
  flags = 0 ;			/* TODO */
  naddr = Wosize_val(sina_v) ;
 
  size = Wosize_bosize(sizeof(*msg) + sizeof(struct sockaddr) * naddr + 8) ;

  /* Allocate and zero the message.
   */
  msg_v = alloc(size, Abstract_tag) ; /* BUG: GC */

  msg = (skt_msg*) &Byte(msg_v, 0) ;
  memset((char*)msg, 0, size) ;

  msg->sock  = sock ;
  msg->flags = flags ;
  msg->naddr = naddr ;
  msg->salen = 0 ;

  for(i=0;i<naddr;i++) {
    get_sockaddr(Field(sina_v,i)) ;
    msg->salen = sock_addr_len ;
    memcpy(&msg->sa[i], &sock_addr, sock_addr_len) ;
  }
#undef sina_v
  Pop_roots() ;
  return msg_v ;
}

/**************************************************************/

value skt_sendopt(
	value msg_v,
	value buf_v,
	value ofs_v,
	value len_v
) {
  skt_msg *msg ;
  char *buf ;
  int len, ofs ;
  int i ;

  SKTTRACE ;
  msg = (skt_msg*) &Byte(msg_v, 0) ;
  ofs = Int_val(ofs_v) ;
  len = Int_val(len_v) ;
  buf = ((char*)&Byte(buf_v,ofs)) ;

  for (i=0;i<msg->naddr;i++) {
    /* Send the message.  Assume we don't block or get interrupted.  
     */
    sendto(msg->sock, buf, len, msg->flags, &msg->sa[i], msg->salen) ;
  }
  return Val_unit ;
}

/**************************************************************/

#ifdef HAS_SENDMSG

#define N_IOVS 10
static struct iovec iov[N_IOVS] ;

static struct msghdr msghdr = {
  NULL,/*(caddr_t) &sin,*/
  0,/*sizeof(sin),*/
  iov,
  0,
  NULL,
  0
} ;

value skt_sendvopt(
	value msg_v,
	value iova_v
) {
  value iov_v, buf_v ;
  int i, nvecs ;
  skt_msg *msg ;
  int len, ofs ;

  SKTTRACE ;
  nvecs = Wosize_val(iova_v) ;	/* inspired by array.c */

  assert(nvecs <= N_IOVS) ;

  for(i=0;i<nvecs;i++) {
    iov_v = Field(iova_v,i) ;
    ofs   = Int_val(Field(iov_v,IOV_OFS)) ;
    len   = Int_val(Field(iov_v,IOV_LEN)) ;
    buf_v = Field(iov_v,IOV_BUF) ;

    /* Could optimize this away.
     */
    msghdr.msg_iov[i].iov_base = (caddr_t) &Byte(buf_v,ofs) ;
    msghdr.msg_iov[i].iov_len  = len ;
  }

  msg = (skt_msg*) &Byte(msg_v, 0) ;

  msghdr.msg_iovlen  = nvecs ;
  msghdr.msg_namelen = msg->salen ;

  for (i=0;i<msg->naddr;i++) {
    /* Send the message.  Assume we don't block or get interrupted.  
     */
    msghdr.msg_name = (char*) &msg->sa[i] ;
    sendmsg(msg->sock, &msghdr, msg->flags) ;
  }
  
  return Val_unit ;
}

#else /* HAS_SENDMSG */

#define FLATTEN_LEN (10 * 1024)
static char flatten_buf[FLATTEN_LEN] ;
/*
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <sys/un.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
*/

/* Version without sendmsg
 */
value skt_sendvopt(
	value msg_v,
	value iova_v
) {
  int i, ret, nvecs, len ;
  int iov_ofs, iov_len ;
  value iov_buf_v ;
  value iov_v ;
  skt_msg *msg ;
  char *buf ;
  SKTTRACE ;

  nvecs = Wosize_val(iova_v) ;	/* inspired by array.c */

  /* Calculate length.
   */
  len = 0 ;
  for (i=0;i<nvecs;i++) {
    iov_v = Field(iova_v,i) ;
    len  += Int_val(Field(iov_v,IOV_LEN)) ;
  }

  /* Either use a preallocated buffer or allocate temporary buffer.  
   */
  if (len < FLATTEN_LEN) {
    buf = flatten_buf ;
  } else {
    buf = stat_alloc(len) ;
  }
  
  /* Copy vectors.
   */
  len = 0 ;
  for(i=0;i<nvecs;i++) {
    iov_v     = Field(iova_v,i) ;
    iov_ofs   = Int_val(Field(iov_v,IOV_OFS)) ;
    iov_len   = Int_val(Field(iov_v,IOV_LEN)) ;
    iov_buf_v = Field(iov_v,IOV_BUF) ;
    bcopy(&Byte(iov_buf_v,iov_ofs), 
	  &buf[len], iov_len) ;
    len += iov_len ;
  }
  
  msg = (skt_msg*) &Byte(msg_v, 0) ;
  
  for (i=0;i<msg->naddr;i++) {
    /* Send the message.  Assume we don't block or get interrupted.  
     */
    sendto(msg->sock, buf, len, msg->flags, &msg->sa[i], msg->salen) ;
  }
  
  if (len < FLATTEN_LEN) {
    /* Do nothing */
  } else {
    stat_free(buf) ;
  }
  
  return Val_int(ret) ;
}    

#endif /* HAS_SENDMSG */

/**************************************************************/

#else

value skt_preprocess() { invalid_argument("preprocess not implemented") ; }
value skt_sendopt()    { invalid_argument("sendopt not implemented") ; }
value skt_sendvopt()   { invalid_argument("sendvopt not implemented") ; }

#endif
