/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*								       */
/*  Extracted from the Unix library and made usable for the Winsock    */
/*  library by Robbert van Renesse at Cornell University.              */
/*                                                                     */
/***********************************************************************/

/* $Id: select.c,v 1.2 1997/04/29 14:41:19 hayden Exp $ */

#include <stdio.h>
#include <string.h>

#include "skt.h"

#if defined(HAS_SELECT) || defined(_WINSOCKAPI_)

#include <sys/types.h>

#ifndef _WINSOCKAPI_
#include <sys/time.h>
#endif

#ifdef HAS_SYS_SELECT_H
#include <sys/select.h>
#endif

#ifdef FD_ISSET
typedef fd_set file_descr_set;
#else
typedef int file_descr_set;
#define FD_SETSIZE (sizeof(int) * 8)
#define FD_SET(fd,fds) (*(fds) |= 1 << (fd))
#define FD_CLR(fd,fds) (*(fds) &= ~(1 << (fd)))
#define FD_ISSET(fd,fds) (*(fds) & (1 << (fd)))
#define FD_ZERO(fds) (*(fds) = 0)
#endif

static void fdlist_to_fdset(fdlist, fdset)
     value fdlist;
     file_descr_set * fdset;
{
  value l;
  int fd;
  FD_ZERO(fdset);
  for (l = fdlist; l != Val_int(0); l = Field(l, 1)) {
    fd = Int_val(Field(l, 0));
    FD_SET(fd, fdset);
  }
}

static value fdset_to_fdlist(fdlist, fdset)
     value fdlist;
     file_descr_set * fdset;
{
  int fd;
  Push_roots(roots, 2)
#define res roots[0]
#define l roots[1]
  res = Val_int(0);
  for (l = fdlist; l != Val_int(0); l = Field(l, 1)) {
    fd = Int_val(Field(l, 0));
    if (FD_ISSET(fd, fdset)) {
      value newres = alloc(2, 0);
      Field(newres, 0) = Val_int(fd);
      Field(newres, 1) = res;
      res = newres;
    }
  }
  Pop_roots();
  return res;
#undef l
#undef res
}

value skt_select(readfds, writefds, exceptfds, timeout) /* ML */
     value readfds, writefds, exceptfds, timeout;
{
  file_descr_set read, write, except;
  double tm;
  struct timeval tv;
  struct timeval * tvp;
  int retcode;
  value res;
  Push_roots(roots, 3);
  roots[0] = readfds ;
  roots[1] = writefds ;
  roots[2] = exceptfds ;
#define readfds roots[0]
#define writefds roots[1]
#define exceptfds roots[2]

  fdlist_to_fdset(readfds, &read);
  fdlist_to_fdset(writefds, &write);
  fdlist_to_fdset(exceptfds, &except);
  tm = Double_val(timeout);
  if (tm < 0.0)
    tvp = (struct timeval *) NULL;
  else {
    tv.tv_sec = (int) tm;
    tv.tv_usec = (int) (1e6 * (tm - (int) tm));
    tvp = &tv;
  }

again:
  retcode = select(FD_SETSIZE, &read, &write, &except, tvp);
  if (retcode == -1 && errno == EINTR)
    goto again ;

  if (retcode == -1) uerror("select", Nothing);
  readfds = fdset_to_fdlist(readfds, &read);
  writefds = fdset_to_fdlist(writefds, &write);
  exceptfds = fdset_to_fdlist(exceptfds, &except);
  res = alloc_tuple(3);
  Field(res, 0) = readfds;
  Field(res, 1) = writefds;
  Field(res, 2) = exceptfds;
  Pop_roots();
  return res;
#undef readfds
#undef writefds
#undef exceptfds
}

#else

value skt_select() { invalid_argument("select not implemented"); }

#endif
